function derivatives=ltiesc_steep_derivatives_iac(t,stuff)

global k1 k icon rho w  xs xsr tstart grad dt CovnT DeltaT p ts tsr;  
global usave tsave 

x = stuff(1:2);
theta1_hat = stuff(3:p^3+2);
theta2_hat = stuff(p^3+3:length(stuff));

x1=x(1);
x2=x(2);

z1=x1;
z2=-x1+x2;

dt=t-tstart;

if t==0  
   error=0; dt=2;
else
   error=norm(x-xs);
end

% the threshold is determined from the robust analysis
if icon==1
   thresh=norm(grad)/200*500
else
    thresh=norm(grad)/20
end

if (dt>=CovnT & error <=thresh) %| (dt>DeltaT)% & error <1) 
%if (error <=thresh) | (dt>DeltaT)% & error <1) 

if icon==1 
      
   % Banana Function
   [f,grad]=banana(x);  % obtain function value and gradient

   % perform an inexact line search satifiying Armijo condition
   % a maximum limit of 50 trial of step size is posted
   % ideally we should impose such a limitation
%    alpha1=1; 
%    for k=1:50     
%        if banana([x1+alpha1*(-grad(1)),x2+alpha1*(-grad(2))]) <= f+rho*alpha1*(-grad.')*grad
%           break;
%        end
%        alpha1=w*alpha1; 
%    end
    alpha1=0.0007; 
elseif icon==0  
   % another cost function   
   grad=[10*x1+4*x2-14;2*x2+4*x1-6];
   %alpha1=((-grad(1))^2+(-grad(2))^2)/(2*(5*(-grad(1))^2+(-grad(2))^2+4*(-grad(1))*(-grad(2))));
   alpha1=0.05;
else
   grad=[2*(1-x1)-4*(x2-x1.^2)*x1;2*(x2-x1.^2)];
   alpha1=0.05;
end
 
% obtained step length
alpha2=alpha1;
xs=[x1-alpha1*grad(1);x2-alpha2*grad(2)];   % ideal search destination
xsr(:,end+1)=xs;
tstart=t;
end

zs(1)=xs(1);
zs(2)=-xs(1)+xs(2);

% generate a periodic refernce trajectory
a2=zs(1);
w1=2*pi/ts;
a1=zs(2)/w1;
 
zs1=a1*sin(w1*t)+a2;
zs2=a1*w1*cos(w1*t);
zs3=-a1*w1*w1*sin(w1*t);

% Indirect Adative Control
% controller parameters
g0 = 0.9;     % lower limit for g
W1 =10;    % a guess
W2=10;
gamma1=2;
gamma2=2;

% error systems
e=k1*(z1-zs1)+(z2-zs2);
xi=k1*(z2-zs2)-zs3;

% function approximator
e_bar= -xi- k*e;      % let this be an input to improve the approximation
alpha1=[0.5*ones(1,3),1];
alpha2=[0.5*ones(1,3),1];
[F,zeta1] = Fu_app([x; e_bar], theta1_hat, alpha1);
[G,zeta2] = Fu_app([x; e_bar], theta2_hat, alpha2);
if G<g0
    G=g0;
end

% Controller
ufl=(1/G)*(-xi-F-k*e);

% controller
% discontinuous stabilizing term
%u_s = -(W + B*abs(e)/(2*g0^2))*sign(e);
% continuous stabilizing term
eps=0.1;
us=(1/g0)*(-W1-W2*abs(ufl))*sat(e/eps);

u = ufl + us;

% Plant dynamics
xprime(1)=-x1+x2;
%xprime(2)=x1*x2+u;
% with bounded input disturbance 
%xprime(2)=x1*x2+(u+2*rand(1)); 
% with unbounded input disturbance
xprime(2) = x1*x2+(u+1/(abs(x1)+1*rand(1))+3*(cos(t)+1)*(x2));

% adaptation laws
theta1_hat_dot = -gamma1.*zeta1.*e;
theta2_hat_dot = -gamma2.*zeta2.*ufl.*e;

% The outputs vector contains the state derivatives and the control signal
derivatives(1:2)=xprime(1:2);
derivatives(3:2+length(theta1_hat))=theta1_hat_dot;
derivatives(3+length(theta1_hat):length(stuff))=theta2_hat_dot;

derivatives = derivatives';

tsave = [tsave;t];
usave = [usave;u];